from django.db import models

# Create your models here.


class LicenseModel(models.Model):
    serial = models.CharField(max_length=128, unique=True,
                              blank=False, null=False,
                              verbose_name='Serial Number', primary_key=True)
    creation_date = models.DateTimeField(auto_now=True)
    activated = models.BooleanField(default=False, verbose_name='Activated')
    activated_due = models.DateField(null=True, verbose_name='Activated due')

