from django.contrib import admin
from .models import LicenseModel


class LicenseAdmin(admin.ModelAdmin):
    date_hierarchy = 'creation_date'
    # exclude = ['licensies']
    readonly_fields = (
        #'serial',
        #'activated_due',
        'creation_date',
        #'activated',
    )

    fields = [( 'serial','activated'), ('activated_due', 'creation_date')]
    # inlines = [LicenseActivatedInfoInline, LicenseHwDataInline ]
    #actions = [make_inactive]
    empty_value_display = ''
    list_display = ('activated','serial','creation_date','activated_due' )
    #list_filter = (LicensesListActivatedFilter, LicensesListCustomersFilter,
    #               LicensesListTypesFilter)
    search_fields = ('serial',)


admin.site.register(LicenseModel, LicenseAdmin)
